function GetJacketPath_a1(song)
	local f={};
	local ret="";
	f=FILEMAN:GetDirListing(song:GetSongDir());
	for i=1,#f do
		if string.find(f[i],".*jacket.*[png$jpeg$jpg$gif$bmp$avi$mpg$mpeg]") then
			if FILEMAN:DoesFileExist(song:GetSongDir().."/"..f[i]) then
				ret=song:GetSongDir().."/"..f[i];
				return ret;
			else
				ret="";
			end;
		end;
	end;
	return ret;
end;

function HasJacket_a1(song)
	local f={};
	local ret="";
	f=FILEMAN:GetDirListing(song:GetSongDir());
	for i=1,#f do
		if string.find(f[i],".*jacket.*[png$jpeg$jpg$gif$bmp$avi$mpg$mpeg]") then
			if FILEMAN:DoesFileExist(song:GetSongDir().."/"..f[i]) then
				return true;
			end;
		end;
	end;
	return false;
end;

function GetCDImagePath_a1(song)
	local f={};
	local ret="";
	f=FILEMAN:GetDirListing(song:GetSongDir());
	for i=1,#f do
		if string.find(f[i],".+cd.?[png$jpeg$jpg$gif$bmp$avi$mpg$mpeg]") then
			if FILEMAN:DoesFileExist(song:GetSongDir().."/"..f[i]) then
				ret=song:GetSongDir().."/"..f[i];
				return ret;
			else
				ret="";
			end;
		end;
	end;
	return ret;
end;

function HasCDImage_a1(song)
	local f={};
	local ret="";
	f=FILEMAN:GetDirListing(song:GetSongDir());
	for i=1,#f do
		if string.find(f[i],".+cd.?[png$jpeg$jpg$gif$bmp$avi$mpg$mpeg]") then
			if FILEMAN:DoesFileExist(song:GetSongDir().."/"..f[i]) then
				return true;
			end;
		end;
	end;
	return false;
end;

--[ja] もっともふさわしい画像のパスを返す 
function GetSongGPath(song)
	local gpath;
	if song then
		if ProductVersion()=="v5.0 alpha 1" then
			--[ja] ジャケット
			if HasJacket_a1(song) then
				gpath=GetJacketPath_a1(song);
			-- [ja] CD
			elseif HasCDImage_a1(song) then
				gpath=GetCDImagePath_a1(song);
			-- [ja] バナー
			elseif song:HasBanner() then
				gpath=song:GetBannerPath();
			-- [ja] BG 
			elseif song:HasBackground() then
				gpath=song:GetBackgroundPath();
			-- [ja] fallback 
			else
				gpath=THEME:GetPathG("Common fallback","background");
			end;
		else
			--[ja] ジャケット
			if song:HasJacket() then
				gpath=song:GetJacketPath();
			-- [ja] CD
			elseif song:HasCDImage() then
				gpath=song:GetCDImagePath();
			-- [ja] バナー
			elseif song:HasBanner() then
				gpath=song:GetBannerPath();
			-- [ja] BG 
			elseif song:HasBackground() then
				gpath=song:GetBackgroundPath();
			-- [ja] fallback 
			else
				gpath=THEME:GetPathG("Common fallback","background");
			end;
		end;
	else
		gpath=THEME:GetPathG("Common fallback","background");
	end;
	return gpath;
end;

--[ja] もっともふさわしい画像のタイプを返す 
function GetSongGType(song)
	local gtype;
	if song then
		if ProductVersion()=="v5.0 alpha 1" then
			--[ja] ジャケット
			--if song:HasJacket() then
			--elseif song:HasCDImage() then
			if HasJacket_a1(song) then
				gtype=3;
			-- [ja] CD
			elseif HasCDImage_a1(song) then
				gtype=4;
			-- [ja] バナー
			elseif song:HasBanner() then
				gtype=1;
			-- [ja] BG 
			elseif song:HasBackground() then
				gtype=2;
			-- [ja] fallback 
			else
				gtype=0;
			end;
		else
			--[ja] ジャケット
			if song:HasJacket() then
				gtype=3;
			-- [ja] CD
			elseif song:HasCDImage() then
				gtype=4;
			-- [ja] バナー
			elseif song:HasBanner() then
				gtype=1;
			-- [ja] BG 
			elseif song:HasBackground() then
				gtype=2;
			-- [ja] fallback 
			else
				gtype=0;
			end;
		end;
	else
		gtype=0;
	end;
	return gtype;
end;